#ifndef __DIRECT_INTERPRETER_H__
#define __DIRECT_INTERPRETER_H__
#include "global.h"

typedef u64 CODE;
typedef u64 DATA;

/* operation codes */

#define OP_ENDCODE	0

#define OP_STOP		(1<<31)

/* 3 argument commands */

/* addition */
#define OP_ADD		8

/* subtraction */
#define OP_SUB		16

/* multiplication */
#define OP_MUL		24

/* and */
#define OP_AND		32

/* or */
#define OP_OR		48

/* strictly less */
#define OP_SLESS	64

/* strictly greater */
#define OP_SGREATER	72

/* branch */
#define OP_BRANCH	80


/* 2 argument commands */

/* constant */
#define OP_CONST	0x8000

#define OP_INFO_AQUI	0x8008


#define DATA1(code,data_in,scratch,data_out)	(((code) & 2) ? (scratch) : (data_in) )
#define DATA2(code,data_in,scratch,data_out)	(((code) & 1) ? (scratch) : (data_in) )
#define RESULT(code,data_in,scratch,data_out)	(((code) & 4) ? (scratch) : (data_out))

int compute(CODE *c, DATA *data_in, DATA *scratch, DATA *data_out);

#endif
